IF EXISTS(SELECT * FROM sys.objects
    WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_VD_PROC]')
          AND type IN(N'P', N'PC'))
    DROP PROCEDURE [dbo].[P_EST_PROD_VD_PROC];
GO
GO
--EXEC P_EST_PROD_VD_PROC 1, 201908

CREATE PROCEDURE P_EST_PROD_VD_PROC @FLAG_DT_ATUAL INT = 0, 
			@ANO_MES_REP INT = NULL
AS
     SET NOCOUNT ON;
     DECLARE @DT_PROC DATETIME;
     DECLARE @ANO     INT
           , @MES     INT
           , @ANO_MES INT;
     
	 SET @DT_PROC = CONVERT(CHAR(10), GETDATE(), 112);
     SET @ANO = YEAR(@DT_PROC);
     SET @MES = MONTH(@DT_PROC);
     SET @ANO_MES = @ANO * 100 + @MES;

     CREATE TABLE #RsProcPendente( CD_CTR BIGINT);
     CREATE TABLE #RsProcVdMesGeral ( CD_EMP  INT
									, CD_PROD INT
									, ANO     INT
									, MES     INT);

     IF @FLAG_DT_ATUAL = 0
         BEGIN
             INSERT INTO #RsProcPendente
                    SELECT
                           V.CD_CTR
                    FROM
                         EST_PROD_CPL_VD_EST_PROD_VD_PENDENTE V
                         INNER JOIN EST_PROD_CPL_VD P ON V.CD_CTR = P.CD_CTR
                    WHERE P.ANO_MES = ANO_MES;
         END;
     IF @FLAG_DT_ATUAL = 1
         BEGIN
             INSERT INTO #RsProcPendente
                    SELECT
                           V.CD_CTR
                    FROM
                         EST_PROD_CPL_VD_EST_PROD_VD_PENDENTE V
                         INNER JOIN EST_PROD_CPL_VD P ON V.CD_CTR = P.CD_CTR
                    WHERE P.ANO_MES <> ANO_MES;
         END;



     INSERT INTO #RsProcVdMesGeral
            SELECT DISTINCT
                   CD_EMP
                 , CD_PROD
                 , ANO
                 , MES
            FROM
                 EST_PROD_CPL_VD V
                 INNER JOIN #RsProcPendente P ON V.CD_CTR = P.CD_CTR
            ORDER BY
                     ANO DESC
                   , MES DESC;

	IF @ANO_MES_REP> 0
	BEGIN
		TRUNCATE TABLE #RsProcVdMesGeral;
		
		INSERT INTO #RsProcVdMesGeral	
		 SELECT DISTINCT
                   CD_EMP
                 , CD_PROD
                 , ANO
                 , MES
            FROM
                 EST_PROD_CPL_VD V
             WHERE  
				V.ANO_MES=@ANO_MES_REP
            ORDER BY
                     ANO DESC
                   , MES DESC; 

	END

--Deletando consolidado filial
     DELETE c
     FROM EST_PROD_VD c
          INNER JOIN #RsProcVdMesGeral procM ON c.CD_EMP = procM.CD_EMP
                                                AND c.CD_PROD = procM.CD_PROD
                                                AND c.ANO = procM.ANO
                                                AND c.MES = procM.MES;
	INSERT INTO EST_PROD_VD(
						CD_EMP
						, CD_PROD
						, ANO
						, MES
						, TIPO_VENDA
						, QT_VD
						, VLR_VD
						, ANO_MES
						, VLR_CUSTO_MD
						, VLR_CUSTO
						, VLR_CUSTO_GER)
    SELECT
            V.CD_EMP
            , V.CD_PROD
            , V.ANO
            , V.MES
            , V.TIPO_VENDA
            , SUM(V.QT_VD)
            , SUM(V.VLR_VD)
            , ANO_MES
            , SUM(VLR_CUSTO_MD)
            , SUM(VLR_CUSTO)
            , SUM(VLR_CUSTO_GER)
    FROM
            EST_PROD_CPL_VD V
            INNER JOIN #RsProcVdMesGeral procM ON V.CD_EMP = procM.CD_EMP
                                                AND V.CD_PROD = procM.CD_PROD
                                                AND V.ANO = procM.ANO
                                                AND V.MES = procM.MES
    GROUP BY
                V.CD_EMP
            , V.CD_PROD
            , V.ANO
            , V.MES
            , V.TIPO_VENDA
            , ANO_MES;


     DELETE P
     FROM EST_PROD_CPL_VD_EST_PROD_VD_PENDENTE P
          INNER JOIN #RsProcPendente pc ON P.CD_CTR = PC.CD_CTR;

     DROP TABLE #RsProcPendente;
     DROP TABLE #RsProcVdMesGeral;

